# 画面設計書 3-Unit Test Generation

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のUnit Test Generation画面（Page ID: 2）の設計書である。Unit Test Generation画面は、utPLSQL準拠のユニットテストパッケージを生成・削除するためのモーダルダイアログ画面である。

### 本画面の処理概要

Unit Test Generation画面は、QUASTOのルールに基づいたutPLSQLユニットテストパッケージを動的に生成する機能を提供する。ユーザーは対象スキーム、生成方式（単一パッケージまたはルールごとのパッケージ）を選択し、テストパッケージの生成または削除を実行できる。

**業務上の目的・背景**：QUASTOはOracleデータベースオブジェクトの品質チェックルールを管理するシステムである。これらのルールを検証するために、utPLSQLフレームワークを使用したユニットテストを実行する必要がある。Unit Test Generation画面は、定義されたルールに基づいてテストパッケージを自動生成することで、手動でのテストコード作成を省き、品質チェックの自動化を実現する。

**画面へのアクセス方法**：Rules画面からモーダルダイアログとして開く。直接URLアクセスは推奨されない。

**主要な操作・処理内容**：
1. 「Create Unit Test Packages」ボタンでテストパッケージを生成
2. 「Delete Unit Test Packages」ボタンで既存テストパッケージを削除
3. 対象スキームを選択（全スキームまたは個別選択）
4. 生成オプションを選択（単一パッケージまたはルールごとにパッケージ分割）

**画面遷移**：
- 遷移元：Rules画面（Generate unit tests for Schemesボタンまたはメニュー）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | Unit Testパッケージ生成 | 主機能 | 定義済みルールに基づいてutPLSQLテストパッケージを自動生成 |
| 21 | Unit Testパッケージ削除 | 主機能 | 生成されたutPLSQLテストパッケージを削除 |

## 画面種別

モーダルダイアログ（設定・実行系）

## URL/ルーティング

- Page ID: 2
- エイリアス: UNIT-TEST-GENERATION
- URL例: `f?p=141:2:SESSION_ID`（ダイアログとして開くことを推奨）

## 入出力項目

### 入力項目

| 項目名 | 項目ID | タイプ | 必須 | データソース/LOV | 説明 |
|--------|--------|--------|------|-----------------|------|
| Scheme Names | P2_SCHEME_NAMES | シャトル | - | QA_SCHEME_NAMES_FOR_TESTING_V | テスト対象スキームの選択（複数選択可） |
| Generation Option | P2_OPTION | ラジオボタン | Yes | 静的値 | パッケージ生成方式の選択 |

### 入力項目詳細

#### P2_SCHEME_NAMES（シャトル）

- **ソース**: QA_SCHEME_NAMES_FOR_TESTING_Vビュー
- **表示値**: USERNAME
- **戻り値**: USERNAME
- **区切り文字**: コロン（:）
- **初期値**: 全スキームが選択状態
- **動作**: 左リストから右リストへスキームを移動して選択

#### P2_OPTION（ラジオボタン）

- **選択肢**:
  - 1: Single Package（1つのパッケージに全ルールのテストを生成）
  - 2: Single Package per Rule（ルールごとに別パッケージを生成）
- **デフォルト**: 1（Single Package）
- **必須**: Yes

### 隠し項目

なし

## 表示項目

### Infoリージョン（情報メッセージ）

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 情報メッセージ | アラート領域 | utPLSQLテストパッケージの生成・削除に関する説明テキスト |

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション | 条件 |
|---------|--------|----------|----------|------|
| Close | CLOSE | CLOSE | ダイアログを閉じる | なし |
| Create Unit Test Packages | CREATE | CREATE | テストパッケージを生成 | P2_OPTION IS NOT NULL |
| Delete Unit Test Packages | DELETE | DELETE | テストパッケージを削除 | なし |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

### 2-Validation before Create

**トリガー**: CREATEボタンクリック（サブミット前のバリデーション）

**バリデーション内容**:
- P2_OPTIONが入力されていること（必須チェック）
- エラーメッセージ: 「Generation Option is required.」

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create Unit Test Packages | USER_OBJECTS | DDL（CREATE） | utPLSQLテストパッケージを動的に生成 |
| Delete Unit Test Packages | USER_OBJECTS | DDL（DROP） | 既存のutPLSQLテストパッケージを削除 |

### プロセス別詳細

#### Create Unit Test Packages

**実行タイミング**: CREATEボタンクリック時

**PL/SQLコード**:
```sql
qa_unit_tests_pkg.p_create_unit_tests_for_schemes(
  pi_option => :P2_OPTION,
  pi_scheme_names => :P2_SCHEME_NAMES
);
```

**処理内容**:
1. P2_SCHEME_NAMESが空の場合は全スキーム対象、そうでなければ指定スキーム対象
2. P2_OPTIONに応じた生成方式でテストパッケージを作成
3. 既存パッケージがある場合は先に削除してから再生成
4. パッケージ仕様部とパッケージ本体を動的に生成

**生成されるオブジェクト**:
- オプション1（Single Package）: `UT_{SCHEME}_{CLIENT}_PKG`
- オプション2（Single Package per Rule）: `UT_{SCHEME}_{CLIENT}_{RULE}_PKG`

#### Delete Unit Test Packages

**実行タイミング**: DELETEボタンクリック時

**PL/SQLコード**:
```sql
qa_unit_tests_pkg.p_delete_unit_tests_for_schemes(pi_scheme_names => :P2_SCHEME_NAMES);
```

**処理内容**:
1. P2_SCHEME_NAMESが空の場合は全UTパッケージ削除、そうでなければ指定スキームのパッケージ削除
2. `UT_%`で始まるパッケージを検索して削除

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 成功 | テストパッケージ生成成功時 | Unit Test Packages created. |
| - | 成功 | テストパッケージ削除成功時 | Unit Test Packages deleted. |
| - | エラー | P2_OPTION未入力時 | Generation Option is required. |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| ルールが未定義 | 「Verification of rules failed: No rules defined.」エラーを表示 |
| 無効なスキーム名 | 「Invalid input parameter value for pi_scheme_names: {スキーム名} - scheme name does not exist」エラーを表示 |
| 無効なオプション値 | 「Invalid input parameter value for pi_option: {値}」エラーを表示 |
| DDL実行エラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |

## 備考

- 本画面はモーダルダイアログとして表示され、親画面（Rules）の上に重ねて表示される
- スキームシャトルはQA_SCHEME_NAMES_FOR_TESTING_Vビューから取得した有効なスキーム名のみ選択可能
- 生成オプション1（Single Package）は全ルールを1つのパッケージにまとめるため、パッケージ数は少ないがパッケージが大きくなる
- 生成オプション2（Single Package per Rule）はルールごとにパッケージを分割するため、パッケージ数は多いが個別管理が容易
- 削除時は確認ダイアログが表示される（「Do you really want to delete these unit test packages?」）
- 生成されるパッケージはutPLSQL形式で、--%suite、--%suitepath、--%testアノテーションを含む

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | モーダルダイアログの構成とアイテム定義 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定（p_page_mode=>'MODAL'）
2. **行25-38**: Infoリージョン（アラートメッセージ）の定義
3. **行39-56**: Unit Test Generationフォームリージョンの定義
4. **行57-76**: Buttons Containerリージョンの定義
5. **行77-153**: ボタン定義（CLOSE、CREATE、DELETE）
6. **行154-194**: アイテム定義（P2_SCHEME_NAMES、P2_OPTION）
7. **行195-240**: プロセス定義（Create/Delete処理）

#### Step 2: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | テストパッケージ生成・削除ロジック |

**主要処理フロー**:
- **行1488-1521**: `p_create_unit_tests_for_schemes`（スキーム名をパースして生成処理を呼び出し）
- **行1523-1552**: `p_delete_unit_tests_for_schemes`（スキーム名をパースして削除処理を呼び出し）
- **行657-823**: `p_create_unit_test_packages`（実際のパッケージ生成ロジック）
- **行825-871**: `p_delete_unit_test_packages`（実際のパッケージ削除ロジック）
- **行403-457**: `f_get_package_spec_header`（パッケージ仕様部ヘッダー生成）
- **行459-491**: `f_get_package_spec_content`（パッケージ仕様部コンテンツ生成）
- **行525-554**: `f_get_package_body_header`（パッケージ本体ヘッダー生成）
- **行556-623**: `f_get_package_body_content`（パッケージ本体コンテンツ生成）

### プログラム呼び出し階層図

```
Unit Test Generation Page (Page 2)
    |
    +-- [Button: CREATE - Submit]
    |       |
    |       +-- Validation: P2_OPTION IS NOT NULL
    |       |
    |       +-- Process: Create Unit Test Packages
    |               |
    |               +-- qa_unit_tests_pkg.p_create_unit_tests_for_schemes
    |                       |
    |                       +-- qa_utils_pkg.f_get_string_as_table
    |                       |
    |                       +-- p_create_unit_test_packages
    |                               |
    |                               +-- p_validate_input
    |                               +-- p_verify_rules
    |                               |       |
    |                               |       +-- qa_main_pkg.f_exist_rules
    |                               |
    |                               +-- p_delete_unit_test_packages (既存削除)
    |                               |
    |                               +-- f_get_all_scheme_names (全スキーム取得)
    |                               |
    |                               +-- [Option 1: Single Package]
    |                               |       +-- f_get_package_spec_header
    |                               |       +-- f_get_package_spec_content (loop)
    |                               |       +-- f_get_package_spec_footer
    |                               |       +-- EXECUTE IMMEDIATE
    |                               |       +-- f_get_package_body_header
    |                               |       +-- f_get_package_body_content (loop)
    |                               |       +-- f_get_package_body_footer
    |                               |       +-- EXECUTE IMMEDIATE
    |                               |
    |                               +-- [Option 2: Single Package per Rule]
    |                                       +-- (同様の処理をルールごとに実行)
    |
    +-- [Button: DELETE - Submit]
    |       |
    |       +-- Confirmation: Do you really want to delete?
    |       |
    |       +-- Process: Delete Unit Test Packages
    |               |
    |               +-- qa_unit_tests_pkg.p_delete_unit_tests_for_schemes
    |                       |
    |                       +-- qa_utils_pkg.f_get_string_as_table
    |                       |
    |                       +-- p_delete_unit_test_packages
    |                               |
    |                               +-- DROP PACKAGE (loop)
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
```

### データフロー図

```
[入力]                      [処理]                           [出力]

P2_SCHEME_NAMES     ───>   qa_utils_pkg                ───> 生成されたパッケージ
(コロン区切り文字列)         .f_get_string_as_table          (USER_OBJECTS)
                                  |
                                  v
P2_OPTION           ───>   qa_unit_tests_pkg           ───> UT_{SCHEME}_{CLIENT}_PKG
(1 or 2)                   .p_create_unit_test_packages     UT_{SCHEME}_{CLIENT}_{RULE}_PKG
                                  |
                                  v
                           QA_RULES テーブル
                           (ルール定義)
                                  |
                                  v
                           EXECUTE IMMEDIATE
                           (DDL実行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | Unit Test Generation画面定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | ユニットテスト生成・実行パッケージ |
| qa_utils_pkg.sql | `src/plsql/pkg/qa_utils_pkg.sql` | ソース | ユーティリティ関数（文字列変換等） |
| qa_main_pkg.sql | `src/plsql/pkg/qa_main_pkg.sql` | ソース | メイン処理パッケージ（ルール検証等） |
| qa_constant_pkg.sql | `src/plsql/pkg/qa_constant_pkg.sql` | ソース | 定数定義パッケージ |
